#!/bin/bash # BeGPL.com's Note: If you did not purchased from us the licensing system will not work at all even if you have source code provided by the leachers, the official versions of Syslic, GBLicense v15, and CPS (Scam), are avaliable at BeGPL only. Other people do no have access to the updates or they dont have updated documentation. We provide free weekly updates on the source code and documentation. ------------ Go To BeGPL.com

ERR_NOT_ROOT=1;
ERR_NOT_KNOWN_OS_ID=2;
ERR_CANNOT_INSTALL_DEPENDENCIES=3;
ERR_CANNOT_DOWNLOAD_INSTALLER=4;

export INSTALLER="/usr/bin/installer_run";

main() {
    echo "";
    echo "";
    echo -e '\E[37;32m''\033[1m*********************************************************************\033[0m';
    echo -e '\E[37;32m''\036[1m                    License Installer                            \033[0m';
    echo -e '\E[37;32m''\036[1m*********************************************************************\033[0m';
    echo "";
    echo "";

    if [ "${EUID}" != 1 -a "$(id -u)" -ne 0 ]; then
        echo "ERROR: Please run installer as root.";
        echo "";
        exit ${ERR_NOT_ROOT};
    fi

    echo "Please note License Installer checks and installs your license requirements." \
         "It might take few minutes to finish installation!";
    echo "Installation begins in 3 seconds...";
    echo "";

    sleep 3;

    if ! install_dependencies "$(get_os_id)"; then
        echo 1>&2 "Cannot install dependencies.";
        exit ${ERR_CANNOT_INSTALL_DEPENDENCIES};
    fi

    download;

    if ! chmod +x "${INSTALLER}"; then
      echo -e "\n${RED}Failed to execute 'chmod +x ${INSTALLER}'. Contact support ${NC}";
      return 1;
    fi

    "${INSTALLER}";
}

download() {
    echo -n "Start downloading primary system...Depending on the speed of your server network, it may take some time ... ";

    rm -rf /usr/local/BLBIN >/dev/null 2>&1;
    rm -rf /root/BLBIN.zip;

    wget >/dev/null 2>&1 --no-check-certificate https://pkg.begpl.com/BLBIN.zip;
    unzip BLBIN.zip -d /usr/local/ >/dev/null 2>&1;

    if ! download_installer; then
        echo -e "\n${RED}File Downloading failed.Renew your license or contact support! ${NC}";

        local header;
        local status;
        local exit_code;

        header=$(download_installer --server-response --spider 2>&1);
        exit_code=${?};

        # Server issued an error response.
        if [ ${exit_code} -eq 8 ]; then
            status=$(echo "${header}" | sed -n '1 s/^[[:space:]]*HTTP\/[0-9.]\+[[:space:]]\+\(.*\)/\1/p');

            case "${status%% *}" in
                403)
                    echo 1>&2 "There is no valid JetBackup V4 License for your server IP";
                    ;;
                *)
                    echo 1>&2 "${status}";
            esac
        fi

        exit ${ERR_CANNOT_DOWNLOAD_INSTALLER};
    fi

    echo -e "\n${GREEN}Completed!${NC}";

    if [ ! -f "${INSTALLER}" ]; then
        echo -e "${RED} File ${INSTALLER} not found. Contact support ${NC}";
        return 1;
    fi
}

download_installer() {
    wget \
        -qq \
        --timeout=15 \
        --tries=5 \
        -O "${INSTALLER}" \
        --no-check-certificate \
        "${@}" \
        https://api.begpl.com/api/files/dareseller/installer_run;
}

get_os_id() {
    if [ -f "/etc/os-release" ]; then
        . /etc/os-release;
        echo ${ID};
        return;
    fi

    if [ -f "/etc/redhat-release" ]; then
        echo "redhat";
        return;
    fi

    if is_command lsb-release; then
        get_lsb_release;
    fi

    return 1;
}

is_command() {
    command 1>/dev/null -v "${1}";
}

get_lsb_release() {
    lsb-release -a \
        | sed -n 's/.*[[:space:]]\+ID:[[:space:]]*\([[:alpha:]]\+\)/\1/p' \
        | tr '[:upper:]' '[:lower:]'
}


install_dependencies() {
    # See https://gist.github.com/natefoo/814c5bf936922dad97ff
    case "${1}" in 
        centos|rhel|redhat)
            yum install -y compat-openssl10* libnsl libssl compat-openssl10 unzip;
            yum update -y ca-certificates;
            ;;
        fedora)
            dnf install -y compat-openssl10* libnsl libssl compat-openssl10 unzip;
            dnf update -y ca-certificates;
            ;;
        debian|ubuntu)
            apt-get install -y compat-openssl10 libnsl libssl unzip;
            install_debian_libraries;
            ;;

        # amzn) ;;
        # arch) ;;
        # opensuse) ;;
        # sles) ;;
        *)
            if is_command yum; then
                install_dependencies "redhat";
                return $?;
            fi

            if is_command apt-get; then
                install_dependencies "debian";
                return $?;
            fi

            echo 1>&2 "Not know Operating System: ${1}";
            exit ${ERR_NOT_KNOWN_OS_ID};
        ;;
    esac
}

install_debian_libraries() {
    rm -rf /usr/lib/x86_64-linux-gnu/libssl.so.10;
    rm -rf /usr/lib/x86_64-linux-gnu/libcrypto.so.10;

    wget >/dev/null 2>&1 \
        -O /lib/x86_64-linux-gnu/libssl.so.10 \
        --no-check-certificate \
        https://pkg.begpl.com/libssl.so.10;

    wget >/dev/null 2>&1 \
        -O /lib/x86_64-linux-gnu/libcrypto.so.10 \
        --no-check-certificate \
        https://pkg.begpl.com/libcrypto.so.10;
}

install_centos_libraries() {
    rm -rf /usr/lib/x86_64-linux-gnu/libssl.so.10;
    rm -rf /usr/lib/x86_64-linux-gnu/libcrypto.so.10;

    wget \
        -O /usr/lib64/libssl.so.10 \
        --no-check-certificate \
        https://pkg.begpl.com/libssl.so.10 >/dev/null 2>&1;

    wget \
        -O /usr/lib64/libcrypto.so.10 \
        --no-check-certificate \
        https://pkg.begpl.com/libcrypto.so.10 >/dev/null 2>&1;
}

main "${@}";

